/**
   FlashingLedFile.ino
      by Matthew Ford,  2020/01/27
   (c)2019 Forward Computing and Control Pty. Ltd.
   NSW, Australia  www.forward.com.au
*/
// this sketch runs on Uno and most other Arduino boards
// it uses millisDelay from https://www.forward.com.au/pfod/ArduinoProgramming/TimingDelaysInArduino.html
// download and install the millisDelay library https://www.forward.com.au/pfod/ArduinoProgramming/millisDelay.zip
#include "millisDelay.h"
#include "TogglePin.h" // for the flashing methods

millisDelay increaseTogglingDelay;
unsigned long INCREASE_TOGGLING_DELAY_MS = 8000; // stop flashing in 8sec

void setup() {
  togglePinInit(13); // built in led
  startTogglingPin();
  increaseTogglingDelay.start(INCREASE_TOGGLING_DELAY_MS);
}

void loop() {
  handleTogglingPin();  // check if led should be toggled
  if (increaseTogglingDelay.justFinished()) {
    setTogglingSpeed(100);  // toggle pin every 1/10 sec
  }
}
