/**
   TogglePin.cpp
      by Matthew Ford,  2020/01/27
   (c)2019 Forward Computing and Control Pty. Ltd.
   NSW, Australia  www.forward.com.au
*/
// this sketch runs on Uno and most other Arduino boards
// it uses millisDelay from https://www.forward.com.au/pfod/ArduinoProgramming/TimingDelaysInArduino.html
// download and install the millisDelay library https://www.forward.com.au/pfod/ArduinoProgramming/millisDelay.zip
#include "Arduino.h"  //  for all the 'standard' Arduino stuff like OUTPUT
#include "millisDelay.h"
#include "TogglePin.h"

// add the static modifier to limit visibility of these variables to just this file
static int pin = -1; // set to -1 to indicate not initialized yet
static bool pinHigh = false; // is the pin is High
static millisDelay pinToggleDelay;
static unsigned long PIN_TOGGLE_DELAY_MS = 1000; // on/delay in mS == 1sec  default value

// call this to start toggling
void startTogglingPin() {
  if (pin < 0) {
    return; //pin not set
  }
  pinToggleDelay.start(PIN_TOGGLE_DELAY_MS); // start led flash delay
  digitalWrite(pin, HIGH); // turn led on
  pinHigh = true; // on
}

// call this to stop toggling
void stopTogglingPin() {
  if (pin < 0) {
    return; //pin not set
  }
  pinToggleDelay.stop(); // stop the led flash delay
  digitalWrite(pin, LOW); // turn led off
  pinHigh = false; // off
}

void togglePinInit(int pinNo) {
  pin = pinNo;
  if (pin >= 0) {
    pinMode(pin, OUTPUT); // set output
    stopTogglingPin();
  }
}

// call this from loop() to check if pin should toggle
void handleTogglingPin() {
  if (pin < 0) {
    return; //pin not set
  }
  if (pinToggleDelay.justFinished()) {
    pinToggleDelay.restart(); // restart it
    pinHigh = !pinHigh; // toggle pinHigh
    if (pinHigh) {
      digitalWrite(pin, HIGH); // turn on
    } else {
      digitalWrite(pin, LOW); // turn off
    }
  }
}

/* setTogglingSpeed call this to change the flash speed
   @param mSDelay -- the new delay in milliseconds
*/
void setTogglingSpeed(unsigned long mSDelay) {
  PIN_TOGGLE_DELAY_MS = mSDelay;
  if (pinToggleDelay.isRunning()) {
    // restart it now with new delay
    pinToggleDelay.start(PIN_TOGGLE_DELAY_MS);
  }
}
