// Dwg_trigSlider.cpp  file ==============
// generated by pfodWeb Designer Arduino Export V2.0.4 -- 24nd October 2025
/*   
 * (c)2025 Forward Computing and Control Pty. Ltd.
 * NSW Australia, www.forward.com.au
 * This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 * This generated code may be freely used for both private and commercial use
 * provided this copyright is maintained.
 */

#include "Dwg_trigSlider.h"
#include <pfodDebugPtr.h>
#include "C4001_SafeString_Wrapper.h"

//#define DEBUG
static Print* debugPtr = NULL;  // local to this file

Dwg_trigSlider dwg_trigSlider;


static unsigned long dwgRefresh = 0;

Dwg_trigSlider::Dwg_trigSlider() {
  initialized = false;
}

void Dwg_trigSlider::init() {
  if (initialized) {
    return;
  }
  initialized = true;
  (void)debugPtr;  // suppress unused warning
#ifdef DEBUG
  debugPtr = getDebugPtr();
#endif
  pfodDrawing::init();
}

// return true if handled else false
// either handle cmd here or in main sketch
bool Dwg_trigSlider::processDwgCmds() {
// byte dwgCmd = parserPtr->parseDwgCmd(); // pfodParse calls this automagically before calling this method
  if (!(*(parserPtr->getDwgCmd()))) {  // ==> getDwgCmd returned pointer to empty string
    return false; // not dwg cmd, not handled
  }
  if (parserPtr->dwgCmdEquals(cmd_buttonSlider)) { // handle touchZone cmd_buttonSlider
    // parserPtr->printDwgCmdReceived(debugPtr); // does nothing if passed NULL
    // add your cmd handling code here
    C4001_controls.setTrigSensitivity(parserPtr->getTouchedCol());
    sendUpdate();
    return true;
  }

  // if (debugPtr) { debugPtr->print("dwgCmd did not match:"); debugPtr->println(cmd_c1); }
  return false; // not handled
}

bool Dwg_trigSlider::sendDwg() {
  if (!parserPtr->cmdEquals(*this)) {
    return false; // not this dwg's loadCmd
  }  // else
  if (parserPtr->isRefresh()) { // refresh just send update
    sendUpdate();
  } else {
    sendFullDrawing();
  }
  return true;
}

// all the indexed items are included here, edit as needed for updates
void Dwg_trigSlider::sendIndexedItems() {
    dwgsPtr->circle().filled().idx(idx_sliderButton).color(dwgsPtr->RED).radius(0.3).offset(C4001_controls.getTrigSensitivity(),1.5).send();
    dwgsPtr->label().idx(idx_label).color(dwgsPtr->BLACK_WHITE).text("Trigger Sensitivity ").fontSize(-9).offset(4.5,2.4).center().intValue(C4001_controls.getTrigSensitivity()).maxValue(9).minValue(0).displayMax(9).displayMin(0).decimals(0).send();
}
        
void Dwg_trigSlider::sendFullDrawing() {
    // Start the drawing
    dwgsPtr->start(9, 4, dwgsPtr->BLUE);
    parserPtr->sendRefreshAndVersion(dwgRefresh); // sets version and refresh time for dwg pfodWeb processes this
    dwgsPtr->pushZero(0, 1, 1);
    dwgsPtr->rectangle().filled().centered().rounded().color(dwgsPtr->BLACK_WHITE).size(9,0.3).offset(4.5,1.5).send();
    dwgsPtr->index().idx(idx_sliderButton).send(); // place holder for indexed item
    dwgsPtr->touchZone().cmd(cmd_buttonSlider).centered().size(9,2).offset(4.5,2).filter(dwgsPtr->DOWN_DRAG_UP).send();
    dwgsPtr->touchAction().cmd(cmd_buttonSlider).action(dwgsPtr->line().idx(idx_line).color(dwgsPtr->BLACK_WHITE).size(0,-1.3).offset(dwgsPtr->TOUCHED_COL,1.5)).send();
    dwgsPtr->touchAction().cmd(cmd_buttonSlider).action(dwgsPtr->label().idx(idx_value).color(dwgsPtr->BLACK_WHITE).text("").fontSize(-7).offset(dwgsPtr->TOUCHED_COL,-0.3).center().intValue(dwgsPtr->TOUCHED_COL).maxValue(9).minValue(0).displayMax(9).displayMin(0).decimals(0)).send();
    dwgsPtr->index().idx(idx_line).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_value).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_label).send(); // place holder for indexed item
    dwgsPtr->popZero();
    sendIndexedItems(); // update indexed items with their real values
    dwgsPtr->end();
}
        
// only indexed items can be sent as an update
// all the indexed items are included here, edit as needed
void Dwg_trigSlider::sendUpdate() {
    dwgsPtr->startUpdate();
    sendIndexedItems(); // send updated indexed items        
    dwgsPtr->end();
}
// ============== end of Dwg_trigSlider.cpp  file 
