/*
   (c)2014-2017 Forward Computing and Control Pty. Ltd.
   NSW Australia, www.forward.com.au
   This code is not warranted to be fit for any purpose. You may only use it at your own risk.
   This code may be freely used for both private and commercial use
   Provide this copyright is maintained.
*/

#include "GarageDoorButton.h"

GarageDoorButton::GarageDoorButton(char _cmd, pfodDwgs *_dwgsPtr) : pfodControl(_dwgsPtr) {
  buttonCmd = _cmd;
  z_idx = pfodDwgs::reserveIdx(1); // z_idx to fill button over text
}

char GarageDoorButton::getCmd() {
  return buttonCmd;
}

void GarageDoorButton::draw() {
  // circle in a rectangle with a label below
  dwgsPtr->rectangle().color(dwgsPtr->SILVER).rounded().size(12, 5.5).offset(-6, -2.75).send();
  if (label != NULL) { // only send label if one set
    dwgsPtr->label().fontSize(+2).text(label).bold().color(dwgsPtr->BLACK).offset(0, 0).send();
  }
  dwgsPtr->touchZone().cmd(buttonCmd).size(12, 5.5).offset(-6, -2.75).send();
  dwgsPtr->touchAction().cmd(buttonCmd).action( //
    dwgsPtr->rectangle().idx(z_idx).filled().color(dwgsPtr->BLACK).rounded().size(12, 5.5).offset(-6, -2.75)
    // what to show when zone touched, note no .send() for this
  ).send();
  update(); // update with current state
}

void GarageDoorButton::update() {
  // nothing here just remove the touchAction above
}
