/*
   (c)2014-2017 Forward Computing and Control Pty. Ltd.
   NSW Australia, www.forward.com.au
   This code is not warranted to be fit for any purpose. You may only use it at your own risk.
   This code may be freely used for both private and commercial use
   Provide this copyright is maintained.
*/

#include "VGuageGarageDoor.h"

VGuageGarageDoor::VGuageGarageDoor(pfodDwgs *_dwgsPtr) : pfodControl(_dwgsPtr) {
  z_idx = pfodDwgs::reserveIdx(3); // z_idx for end of slider, slider and label
}


void VGuageGarageDoor::draw() {
  dwgsPtr->pushZero(0, 0, 0.125);  // scale down 255 to 32 cols
  dwgsPtr->rectangle().filled().color(dwgsPtr->GREY).size(1, -255).offset( -0.5, 0).send();

  dwgsPtr->label().fontSize(18).text("Closed").color(dwgsPtr->BLACK).offset(-40, 0).send();
  dwgsPtr->line().color(dwgsPtr->BLACK).offset( -7.5, 0).size( 15, 0).send();
  dwgsPtr->label().fontSize(18).text("Open").color(dwgsPtr->BLACK).offset( -40, -255).send();
  dwgsPtr->line().color(dwgsPtr->BLACK).offset( -7.5, -255).size( 15, 0).send();

  update(); // update with current state
  dwgsPtr->popZero();

  update(); // update with current state
  dwgsPtr->popZero();
}

void VGuageGarageDoor::update() {
  dwgsPtr->rectangle().filled().centered().size(24, 3).idx(z_idx).color(dwgsPtr->BLACK).offset( 0, -value).send();
  dwgsPtr->rectangle().filled().idx(z_idx + 1).color(dwgsPtr->BLACK).size(12, -255 + value).offset(-6, -value).send();
  dwgsPtr->label().text(label).idx(z_idx + 2).bold().fontSize(28).color(dwgsPtr->BLACK).offset(-10, 35).send();
}
