/*
 pfodParserMicroBit library V1.0   20th October 2016 (www.pfod.com.au)
 (c)2016 Forward Computing and Control Pty. Ltd.
 This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 This code may be freely used for both private and commercial use.
 Provide this copyright is maintained.
 */

#ifndef MANAGED_PRINTF_H
#define MANAGED_PRINTF_H

/**
 * ManagedPrintf::printf(const char *format, ...) returns a ManagedString
 * 
 * @param format,  printf format 
 * @param ... ,  extra args for printf
 * @return ManagedString
 * 
 * Example:
 *    ManagedString mStr = ManagedPrintf::printf("loop count:%lu\n", counter);
 *    uBit.serial.send(mStr);
 * OR
 *    uBit.serial.send(ManagedPrintf::printf("loop count:%lu\n", counter));
 * 
 */

#include <cstdarg>
#include "ManagedString.h"

class ManagedPrintf {
public:
    static ManagedString printf(const char *format, ...);
    static ManagedString getAddress(void* obj);
    static const int MANAGED_PRINT_MAX_ON_STACK = 60;
};
#endif
