// =============  start of pfodMenu.h file =============
/* ===== pfod Command for BBC micro:bit ====
pfodApp msg {.} --> {,~<+2>Empty Menu</+2>
use pfodDesignerV2
to design a menu`0~V0}
 */
/* 
 * File:   pfodMenu.h for BBC micro:bit
 */
/*
 pfodParserMicroBit library V1.0   20th October 2016 (www.pfod.com.au)
 (c)2016 Forward Computing and Control Pty. Ltd.
 This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 This code may be freely used for both private and commercial use.
 Provide this copyright is maintained.
 */

#ifndef PFODMENU_H
#define PFODMENU_H
#include <stdint.h>
#include "pfodParser.h"
#include "MicroBit.h"


class pfodMenu : pfodParser {
public:
  // public vars set by parser, access and update these in your main program
  unsigned long plotTime; // used in sendData in main.cpp and below
  void sendData(void); // This method is call automatically if plotInterval > 0   You can also call it from your own fiber
  
  bool isConnected(void); // set true when {.} parsed, set false when {!} parsed.
  pfodMenu(void);
  void init(MicroBit* _uBit);

private:
  void sendMainMenu();
  void sendMainMenuUpdate();
  
  static const int maxRxMsgSize; //max size of pfodCmd ALWAYS <= 255
  static const unsigned long plotInterval; // used to sendData in main.cpp
  void initGlobalVars(void);
  void createStream();
  void processCmd(); 
  static void fiber_SendData(void);
  static void pfodAppDisconnected(MicroBitEvent);
  static void pfodProcessRx(MicroBitEvent);
  static const char *vers; // the menu version no
  static pfodMenu* menuParserPtr;
};
#endif /* PFODMENU_H */
// ===============  end of pfodMenu.h file ================
