/*
 pfodParserMicroBit library V1.0   20th October 2016 (www.pfod.com.au)
 (c)2016 Forward Computing and Control Pty. Ltd.
 This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 This code may be freely used for both private and commercial use.
 Provide this copyright is maintained.
 */

#ifndef PFODPARSERSTREAM_H
#define PFODPARSERSTREAM_H

#include <stdint.h>
#include <stddef.h>

#define UNUSED(x) (void)(x)

//#define PFOD_BLE_UART_NO_DATA       -1
#define PFOD_ID_UART          4989

#define PFOD_UART_EVT_DATA_AVAILABLE   1
#define PFOD_UART_DATA_SENT 2
#define PFOD_PARSER_STREAM_FREE 3


class pfodParserStream {
public:
    virtual int init()= 0; // clears tx/rx buffers
    virtual size_t available(void) = 0; // return bytes available for read()
    virtual int read(void) = 0; // read an input byte from rx buffer. Note: may block if none avaliable or return -1 guard with if (available()))
    virtual size_t txFree(void) = 0; // return space available for write();
    virtual int write(uint8_t c) = 0; // write to tx buffer. Note: spins if no space to write
    virtual void flush(void) = 0; // force write of buffed bytes if any
    virtual bool isBle(void) = 0; // is this a BLE stream
    static const int PFOD_UART_NO_DATA = -1;
private:
    pfodParserStream& operator=(const pfodParserStream&);
};
#endif /* PFODPARSERSTREAM_H */

