#include "SliderControls.h"
#include <SafeString.h>
#include <pfodDebugPtr.h>

#define DEBUG
static Print* debugPtr = NULL;  // local to this file

float position;
cSF(sfPosition, 20);
cSF(sfErrMsg, 30);

SafeString& getErrMsg() {
  return sfErrMsg;
}

void setPosition(char* str) {
#ifdef DEBUG
  debugPtr = getDebugPtr();
#endif
  sfErrMsg.clear();
  sfPosition.clear();
  sfPosition.readFrom(str);            // reads at most 20 chars from the edited text
  if (sfPosition.toFloat(position)) {  // if it is a valid float, limit it
    if (position < 0) {
      position = 0;
      sfErrMsg.print(sfPosition);
      sfErrMsg.println(" limited to 0");
    }
    if (position > 100) {
      position = 100;
      sfErrMsg.print(sfPosition);
      sfErrMsg.println(" limited to 100");
    }
  } else {
    // not a valid float. print/send an error.
    sfErrMsg.print(sfPosition);
    sfErrMsg.println(" is not a valid float.");

    if (debugPtr) {
      debugPtr->println(sfErrMsg);
    }
  }
}

void setPosition(float pos) {
  sfErrMsg.clear();
  position = pos;
}

float getPosition() {
  return position;
}
