// Dwg_SliderInput.cpp  file ==============
// generated by pfodWeb Designer Arduino Export V2.0.0 -- 13th October 2025
/*   
 * (c)2025 Forward Computing and Control Pty. Ltd.
 * NSW Australia, www.forward.com.au
 * This code is not warranted to be fit for any purpose. You may only use it at your own risk.
 * This generated code may be freely used for both private and commercial use
 * provided this copyright is maintained.
 */

#include "Dwg_SliderInput.h"
#include <pfodDebugPtr.h>
#include "SliderControls.h"

//#define DEBUG
static Print* debugPtr = NULL;  // local to this file

Dwg_SliderInput dwg_SliderInput;


static unsigned long dwgRefresh = 0;

Dwg_SliderInput::Dwg_SliderInput() {
  initialized = false;
}

void Dwg_SliderInput::init() {
  if (initialized) {
    return;
  }
  initialized = true;
  (void)debugPtr;  // suppress unused warning
#ifdef DEBUG
  debugPtr = getDebugPtr();
#endif
  pfodDrawing::init();
}

// return true if handled else false
// either handle cmd here or in main sketch
bool Dwg_SliderInput::processDwgCmds() {
// byte dwgCmd = parserPtr->parseDwgCmd(); // pfodParse calls this automagically before calling this method
  if (!(*(parserPtr->getDwgCmd()))) {  // ==> getDwgCmd returned pointer to empty string
    return false; // not dwg cmd, not handled
  }
  if (parserPtr->dwgCmdEquals(cmd_slider)) { // handle touchZone cmd_slider
    // parserPtr->printDwgCmdReceived(debugPtr); // does nothing if passed NULL
    // add your cmd handling code here
    setPosition(parserPtr->getTouchedCol());
    sendUpdate();
    return true;
  }
  if (parserPtr->dwgCmdEquals(cmd_input)) { // handle touchZone cmd_input
    // parserPtr->printDwgCmdReceived(debugPtr); // does nothing if passed NULL
    // add your cmd handling code here
    setPosition((char*)parserPtr->getEditedText());
    sendUpdate();
    return true;
  }

  // if (debugPtr) { debugPtr->print("dwgCmd did not match:"); debugPtr->println(cmd_c1); }
  return false; // not handled
}

bool Dwg_SliderInput::sendDwg() {
  if (!parserPtr->cmdEquals(*this)) {
    return false; // not this dwg's loadCmd
  }  // else
  if (parserPtr->isRefresh()) { // refresh just send update
    sendUpdate();
  } else {
    sendFullDrawing();
  }
  return true;
}

// all the indexed items are included here, edit as needed for updates
void Dwg_SliderInput::sendIndexedItems() {
    dwgsPtr->rectangle().filled().idx(idx_ribbon).color(dwgsPtr->RED).size(getPosition(),5).offset(0,16).send();
    dwgsPtr->label().idx(idx_sliderLabel).color(dwgsPtr->WHITE).text("Slider ").fontSize(8).offset(50,28.5).center().units("%").decimals(2).value(getPosition()).send();
    dwgsPtr->label().idx(idx_hidden).color(dwgsPtr->BLACK_WHITE).text("").offset(1,2).left().decimals(2).value(getPosition()).send();
}
        
void Dwg_SliderInput::sendFullDrawing() {
    // Start the drawing
    dwgsPtr->start(110, 40, dwgsPtr->BLUE);
    parserPtr->sendRefreshAndVersion(dwgRefresh); // sets version and refresh time for dwg pfodWeb processes this
    dwgsPtr->pushZero(5, 0, 1);
    dwgsPtr->rectangle().filled().color(dwgsPtr->WHITE).size(100,5).offset(0,16).send();
    dwgsPtr->index().idx(idx_ribbon).send(); // place holder for indexed item
    dwgsPtr->touchZone().cmd(cmd_slider).size(100,5).offset(0,16).filter(dwgsPtr->DOWN_DRAG_UP).send();
    dwgsPtr->touchAction().cmd(cmd_slider).action(dwgsPtr->line().idx(idx_2).color(dwgsPtr->WHITE).size(0,-7).offset(dwgsPtr->TOUCHED_COL,16)).send();
    dwgsPtr->touchAction().cmd(cmd_slider).action(dwgsPtr->label().idx(idx_3).color(dwgsPtr->WHITE).text("").offset(dwgsPtr->TOUCHED_COL,7).center().intValue(dwgsPtr->TOUCHED_COL).units("%").maxValue(100).minValue(0).displayMax(100).displayMin(0).decimals(0)).send();
    dwgsPtr->index().idx(idx_2).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_3).send(); // place holder for indexed item
    dwgsPtr->index().idx(idx_sliderLabel).send(); // place holder for indexed item
    dwgsPtr->touchZone().cmd(cmd_input).centered().size(50,10).offset(50,28.5).send();
    dwgsPtr->touchActionInput().cmd(cmd_input).prompt("Slider %").textIdx(idx_hidden).fontSize(2).color(dwgsPtr->WHITE).backgroundColor(dwgsPtr->BLACK).send();
    dwgsPtr->index().idx(idx_hidden).send(); // place holder for indexed item
    dwgsPtr->hide().idx(idx_hidden).send();
    sendIndexedItems(); // update indexed items with their real values
    dwgsPtr->end();
}
        
// only indexed items can be sent as an update
// all the indexed items are included here, edit as needed
void Dwg_SliderInput::sendUpdate() {
    dwgsPtr->startUpdate();
    sendIndexedItems(); // send updated indexed items        
    dwgsPtr->end();
}
// ============== end of Dwg_SliderInput.cpp  file 
