#include "SliderControls.h"
#include <SafeString.h>
#include <pfodDebugPtr.h>

#define DEBUG
static Print* debugPtr = NULL;  // local to this file

float position;
cSF(sfPosition, 20);

void setPosition(char* str) {
#ifdef DEBUG
  debugPtr = getDebugPtr();
#endif

  sfPosition.clear();
  sfPosition.readFrom(str);            // reads at most 20 chars from the edited text
  if (sfPosition.toFloat(position)) {  // if it is a valid float, limit it
    if (position < 0) { position = 0; }
    if (position > 100) { position = 100; }
  } else {
    // not a valid float. print/send an error.
    if (debugPtr) {
      debugPtr->print(sfPosition);
      debugPtr->println(" is not a valid float.");
    }
  }
}

void setPosition(float pos) {
  position = pos;
}

float getPosition() {
  return position;
}
